CREATE OR REPLACE FORCE VIEW w83b.w83bcertdelegadossector (codsector,
                                                           codsindicato,
                                                           descsindcast,
                                                           descsindeusk,
                                                           felec,
                                                           territ,
                                                           delegado
                                                          )
AS
   SELECT centro.codsector, delegado.c_sindi_025, sindicato.desc_019,
          sindicato.dese_019, acta.f_elecc_016, acta.c_territ_016,
          delegado.dni_025
     FROM w83b16s00 acta,
          w83bcentrotrabajocompleto centro,
          w83b25s00 delegado,
          w83b19s00 sindicato
    WHERE acta.id_centro_016 = centro.codcentro
      AND acta.c_territ_016 = delegado.c_territ_025
      AND acta.ano_acta_016 = delegado.ano_acta_025
      AND acta.n_acta_016 = delegado.n_acta_025
      AND acta.version_016 = delegado.version_025
      AND delegado.c_sindi_025 = sindicato.c_sindi_019
      AND delegado.f_baja_025 IS NULL
      AND acta.validada_016 = 1
      AND acta.version_016 =
             (SELECT MAX (act.version_016)
                FROM w83b16s00 act
               WHERE acta.n_acta_016 = act.n_acta_016
                 AND acta.ano_acta_016 = act.ano_acta_016
                 AND acta.c_territ_016 = act.c_territ_016
                 AND act.validada_016 = 1);
/			
CREATE OR REPLACE FORCE VIEW w83bcertempresa (siglas,
                                                   razon,
                                                   descsindcast,
                                                   descsindeusk,
                                                   codcentro,
                                                   fecha_eleccion,
                                                   codsindicato,
                                                   fecha_alta,
                                                   numeroregistro,
                                                   fecha_registro,
                                                   observaciones,
                                                   actatotal,
                                                   num_acta,
                                                   anyo_acta,
                                                   territorio_acta,
                                                   alava,
                                                   vizcaya,
                                                   guipuzcoa,
                                                   cif,
                                                   numero
                                                  )
AS
   SELECT   siglas, razon, desc_019 AS desccast, dese_019 AS desceusk,
            codigocentro, fecha_eleccion, c_sindi_019 AS codsind, fechaalta,
            numeroregistro, fecharegistro, observaciones, acta, num_acta,
            anyo_acta, territorio_acta,
            NVL (SUM (CASE
                         WHEN (territorio_acta = 01)
                            THEN 1
                         ELSE 0
                      END), 0) AS alava,
            NVL (SUM (CASE
                         WHEN (territorio_acta = 48)
                            THEN 1
                         ELSE 0
                      END), 0) AS vizcaya,
            NVL (SUM (CASE
                         WHEN (territorio_acta = 20)
                            THEN 1
                         ELSE 0
                      END),
                 0
                ) AS guipuzcoa,
            ccif_001, ncen_001
       FROM (SELECT acta.n_acta_016 AS num_acta,
                    acta.ano_acta_016 AS anyo_acta,
                    acta.c_territ_016 AS territorio_acta,
                    acta.version_016 AS versionacta,
                    del.c_sindi_025 AS sindicato, sind.siglas_019 AS siglas,
                    del.dni_025 AS dni, desc_019 AS desc_019,
                    dese_019 AS dese_019, c_sindi_019, rsoc_001 AS razon,
                    f_elecc_016 AS fecha_eleccion, f_entra_016 AS fechaalta,
                    (   c_territ_016
                     || '/'
                     || ano_regdef_016
                     || '/'
                     || DECODE (LENGTH (TO_CHAR (n_regdef_016)),
                                1, '00000' || TO_CHAR (n_regdef_016),
                                2, '0000' || TO_CHAR (n_regdef_016),
                                3, '000' || TO_CHAR (n_regdef_016),
                                4, '00' || TO_CHAR (n_regdef_016),
                                5, '0' || TO_CHAR (n_regdef_016),
                                TO_CHAR (n_regdef_016)
                               )
                    ) numeroregistro,
                    (   acta.c_territ_016
                     || '/'
                     || acta.ano_acta_016
                     || '/'
                     || DECODE (LENGTH (TO_CHAR (acta.n_acta_016)),
                                1, '00000' || TO_CHAR (acta.n_acta_016),
                                2, '0000' || TO_CHAR (acta.n_acta_016),
                                3, '000' || TO_CHAR (acta.n_acta_016),
                                4, '00' || TO_CHAR (acta.n_acta_016),
                                5, '0' || TO_CHAR (acta.n_acta_016),
                                TO_CHAR (acta.n_acta_016)
                               )
                    ) acta,
                    fregdef_016 AS fecharegistro, observ_016 AS observaciones,
                    ccen_001 AS codigocentro, ccif_001, ncen_001
               FROM w83b25s00 del, w83b16s00 acta, w83b19s00 sind, j7301s01
              WHERE del.n_acta_025 = acta.n_acta_016
                AND del.ano_acta_025 = acta.ano_acta_016
                AND del.version_025 = acta.version_016
                AND del.c_territ_025 = acta.c_territ_016
                AND sind.c_sindi_019 = del.c_sindi_025
                AND acta.id_centro_016 = ccen_001
                AND del.f_baja_025 IS NULL
                AND acta.f_baja_016 IS NULL
                AND acta.fregdef_016 IS NOT NULL
                AND acta.n_regdef_016 IS NOT NULL
                AND acta.validada_016 = 1) consulta
      WHERE consulta.versionacta =
               (SELECT MAX (version_016)
                  FROM w83b16s00 act
                 WHERE consulta.num_acta = act.n_acta_016
                   AND consulta.anyo_acta = act.ano_acta_016
                   AND consulta.territorio_acta = act.c_territ_016
                   AND act.validada_016 = 1)
   GROUP BY acta,
            num_acta,
            anyo_acta,
            territorio_acta,
            siglas,
            desc_019,
            dese_019,
            razon,
            codigocentro,
            fecha_eleccion,
            c_sindi_019,
            fechaalta,
            numeroregistro,
            fecharegistro,
            observaciones,
            ccif_001,
            ncen_001;
/
CREATE OR REPLACE FORCE VIEW w83bcertlistadelegados (nombre,
                                                          apellido1,
                                                          apellido2,
                                                          dni,
                                                          siglas,
                                                          fecha_alta,
                                                          territorio_acta,
                                                          anyo_acta,
                                                          num_acta
                                                         )
AS
   SELECT DISTINCT nombre, apellido1, apellido2, dni, siglas, fechaalta,
                   territorio_acta, ano_acta, num_acta
              FROM (SELECT acta.n_acta_016 AS num_acta,
                           acta.ano_acta_016 AS ano_acta,
                           acta.c_territ_016 AS territorio_acta,
                           acta.version_016 AS version_acta,
                           acta.validada_016 AS validada,
                           centros.ccif_001 AS cif, del.nombre_025 AS nombre,
                           del.apel1_025 AS apellido1,
                           del.apel2_025 AS apellido2, del.dni_025 AS dni,
                           sind.siglas_019 AS siglas, desc_019 AS desccentro,
                           del.f_alta_025 AS fechaalta
                      FROM w83b25t00 del,
                           w83b16s00 acta,
                           j7301s01 centros,
                           w83b19s00 sind
                     WHERE del.n_acta_025 = acta.n_acta_016
                       AND del.ano_acta_025 = acta.ano_acta_016
                       AND del.version_025 = acta.version_016
                       AND del.c_territ_025 = acta.c_territ_016
                       AND centros.ccen_001 = acta.id_centro_016
                       AND sind.c_sindi_019 = del.c_sindi_025
                       AND del.f_baja_025 IS NULL
                       AND acta.f_baja_016 IS NULL
                       AND acta.fregdef_016 IS NOT NULL
                       AND acta.n_regdef_016 IS NOT NULL) consulta
             WHERE consulta.version_acta =
                      (SELECT MAX (version_016)
                         FROM w83b16s00 act
                        WHERE consulta.num_acta = act.n_acta_016
                          AND consulta.ano_acta = act.ano_acta_016
                          AND consulta.territorio_acta = act.c_territ_016
                          AND act.validada_016 = 1)
               AND consulta.validada = 1;
/
CREATE OR REPLACE VIEW w83bcertnegrepres (num_acta,
                                          fecha_eleccion,
                                          descsindcast,
                                          descsindeusk,
                                          codcentro,
                                          codsindicato,
                                          territorio_acta
                                         )
AS
   SELECT   (   acta.c_territ_016
             || '/'
             || acta.ano_acta_016
             || '/'
             || DECODE (LENGTH (TO_CHAR (acta.n_acta_016)),
                        1, '00000' || TO_CHAR (acta.n_acta_016),
                        2, '0000' || TO_CHAR (acta.n_acta_016),
                        3, '000' || TO_CHAR (acta.n_acta_016),
                        4, '00' || TO_CHAR (acta.n_acta_016),
                        5, '0' || TO_CHAR (acta.n_acta_016),
                        TO_CHAR (acta.n_acta_016)
                       )
            ) num_acta,
            acta.f_elecc_016 AS fecha_eleccion, sind.desc_019, sind.dese_019,
            acta.id_centro_016 centro, sind.c_sindi_019 AS codsind,
            acta.c_territ_016 AS territ
       FROM w83b16s00 acta, w83b19s00 sind
      WHERE acta.version_016 =
               (SELECT MAX (act.version_016)
                  FROM w83b16s00 act
                 WHERE acta.n_acta_016 = act.n_acta_016
                   AND acta.ano_acta_016 = act.ano_acta_016
                   AND acta.c_territ_016 = act.c_territ_016
                   AND act.validada_016 = 1)
        AND 0 =
               (SELECT COUNT (dele.dni_025)
                  FROM w83b25s00 dele
                 WHERE dele.c_sindi_025 = sind.c_sindi_019
                   AND dele.f_baja_025 IS NULL
                   AND acta.n_acta_016 = dele.n_acta_025
                   AND acta.ano_acta_016 = dele.ano_acta_025
                   AND acta.c_territ_016 = dele.c_territ_025
                   AND acta.version_016 = dele.version_025)
		 AND acta.validada_016=1
   GROUP BY n_acta_016,
            ano_acta_016,
            c_territ_016,
            desc_019,
            dese_019,
            f_elecc_016,
            acta.id_centro_016,
            sind.c_sindi_019;
/
CREATE OR REPLACE FORCE VIEW w83b.w83bcertorganorepr (actatotal,
                                                      num_acta,
                                                      anyo_acta,
                                                      territorio_acta,
                                                      fecha_eleccion,
                                                      razon,
                                                      codprovincia,
                                                      codmunicipio,
                                                      cif,
                                                      numero
                                                     )
AS
   SELECT acta, num_acta, anyo_acta, territorio_acta, fecha_eleccion, empresa,
          codprovincia,codmunicipio, cif, numero
     FROM (SELECT DISTINCT (   acta.c_territ_016
                            || '/'
                            || acta.ano_acta_016
                            || '/'
                            || DECODE (LENGTH (TO_CHAR (acta.n_acta_016)),
                                       1, '00000' || TO_CHAR (acta.n_acta_016),
                                       2, '0000' || TO_CHAR (acta.n_acta_016),
                                       3, '000' || TO_CHAR (acta.n_acta_016),
                                       4, '00' || TO_CHAR (acta.n_acta_016),
                                       5, '0' || TO_CHAR (acta.n_acta_016),
                                       TO_CHAR (acta.n_acta_016)
                                      )
                           ) acta,
                           acta.n_acta_016 AS num_acta,
                           acta.ano_acta_016 AS anyo_acta,
                           acta.c_territ_016 AS territorio_acta,
                           acta.version_016 AS version_acta,
                           acta.f_elecc_016 AS fecha_eleccion,
                           centros.rsoc_001 AS empresa, centros.provc_001 as codprovincia, centros.munic_001 AS codmunicipio,
                           centros.ccif_001 AS cif,
                           centros.ncen_001 AS numero
                      FROM w83b25t00 del,
                           w83b16s00 acta,
                           j7301s01 centros,
                           w83b19s00 sind
                     WHERE del.n_acta_025 = acta.n_acta_016
                       AND del.ano_acta_025 = acta.ano_acta_016
                       AND del.version_025 = acta.version_016
                       AND del.c_territ_025 = acta.c_territ_016
                       AND centros.ccen_001 = acta.id_centro_016
                       AND sind.c_sindi_019 = del.c_sindi_025
                       AND del.f_baja_025 IS NULL
                       AND acta.f_baja_016 IS NULL
                       AND acta.fregdef_016 IS NOT NULL
                       AND acta.n_regdef_016 IS NOT NULL
                       AND acta.validada_016 = 1) consulta
    WHERE consulta.version_acta =
             (SELECT MAX (version_016)
                FROM w83b16s00 act
               WHERE consulta.num_acta = act.n_acta_016
                 AND consulta.anyo_acta = act.ano_acta_016
                 AND consulta.territorio_acta = act.c_territ_016
                 AND act.validada_016 = 1);
/
CREATE OR REPLACE FORCE VIEW w83b.w83bdatosministeriosind (n_acta_016,
                                                           c_territ_016,
                                                           ano_acta_016,
                                                           c_coleg_024,
                                                           n_votos_024,
                                                           n_delh_024,
                                                           n_delm_024,
                                                           c_sindi_024,
                                                           fregdef_016,
                                                           f_elecc_016,
                                                           f_baja_016,
                                                           cmadrid_019
                                                          )
AS
   SELECT   n_acta_016, c_territ_016, ano_acta_016, c_coleg_024, n_votos_024,
            n_delh_024, n_delm_024, c_sindi_024, fregdef_016, f_elecc_016,
            f_baja_016, cmadrid_019
       FROM (SELECT consulta.n_acta_016, consulta.c_territ_016,
                    consulta.ano_acta_016, consulta.c_coleg_024,
                    consulta.n_votos_024 AS n_votos_024,
                    consulta.n_delh_024 AS n_delh_024,
                    consulta.n_delm_024 AS n_delm_024, consulta.c_sindi_024,
                    consulta.fregdef_016, consulta.f_elecc_016,
                    consulta.f_baja_016, consulta.cmadrid_019
               FROM (SELECT version_016, n_acta_016, c_territ_016,
                            ano_acta_016, c_coleg_024,
                            NVL (n_votos_024, 0) AS n_votos_024,
                            NVL ((n_delh_024), '0') AS n_delh_024,
                            NVL ((n_delm_024), '0') AS n_delm_024,
                            c_sindi_024, fregdef_016, f_elecc_016, f_baja_016,
                            cmadrid_019
                       FROM w83b16s00, w83b24s00, w83b19s00
                      WHERE n_acta_016 = n_acta_024
                        AND ano_acta_016 = ano_acta_024
                        AND c_territ_016 = c_territ_024
                        AND version_016 = version_024
                        AND c_sindi_024 = c_sindi_019(+)
                        AND validada_016 = 1) consulta
              WHERE consulta.version_016 =(SELECT MAX (actas.version_016)
                          FROM w83b16s00 actas
                         WHERE consulta.n_acta_016 = actas.n_acta_016
                           AND consulta.ano_acta_016 = actas.ano_acta_016
                           AND consulta.c_territ_016 = actas.c_territ_016
                           AND actas.validada_016 = 1))
   ORDER BY ano_acta_016, n_acta_016, c_territ_016, c_coleg_024;
/
CREATE OR REPLACE FORCE VIEW w83b.w83bdetallecentrosindicato (nacta,
                                                              territ,
                                                              anoacta,
                                                              ver,
                                                              anoregdef,
                                                              nregdef,
                                                              felec,
                                                              cif,
                                                              sector,
                                                              razon,
                                                              ncentro,
                                                              convdesc,
                                                              totalelectores,
                                                              numdelegados,
                                                              sinddesc,
                                                              siglas,
                                                              codsindicato,
                                                              actatotal,
                                                              fechabaja,
                                                              fecharegistro,
                                                              nactacompleta
                                                             )
AS
   SELECT   consulta.nacta, consulta.territ, consulta.anoacta, consulta.ver,
            consulta.anoregdef, consulta.nregdef, consulta.felec,
            consulta.cif, consulta.sector, consulta.razon, consulta.ncentro,
            consulta.convdesc, consulta.totalelectores, consulta.numdelegados,
            consulta.sinddesc, consulta.siglas, consulta.codsindicato,
            consulta.actatotal, consulta.fechabaja, consulta.fecharegistro,
            consulta.nactacompleta
       FROM (SELECT   actas.n_acta_016 AS nacta, actas.c_territ_016 AS territ,
                      actas.ano_acta_016 AS anoacta, actas.version_016 AS ver,
                      actas.ano_regdef_016 AS anoregdef,
                      actas.n_regdef_016 AS nregdef,
                      actas.f_elecc_016 AS felec, centros.ccif_001 AS cif,
                      centros.secc_001 AS sector, centros.rsoc_001 AS razon,
                      centros.ncen_001 AS ncentro,
                      convenios.desc_013 AS convdesc,
                      actas.totelec_016 AS totalelectores,
                      SUM (escrutinios.n_delh_024 + escrutinios.n_delm_024
                          ) AS numdelegados,
                      sindicatos.desc_019 AS sinddesc,
                      sindicatos.siglas_019 AS siglas,
                      sindicatos.c_sindi_019 AS codsindicato,
                      actas.n_acttot_016 AS actatotal,
                      actas.f_baja_016 AS fechabaja,
                      actas.fregdef_016 AS fecharegistro,
                      TO_NUMBER
                         (   actas.c_territ_016
                          || actas.ano_acta_016
                          || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                     1, '00000' || TO_CHAR (actas.n_acta_016),
                                     2, '0000' || TO_CHAR (actas.n_acta_016),
                                     3, '000' || TO_CHAR (actas.n_acta_016),
                                     4, '00' || TO_CHAR (actas.n_acta_016),
                                     5, '0' || TO_CHAR (actas.n_acta_016),
                                     TO_CHAR (actas.n_acta_016)
                                    )
                          || actas.version_016
                         ) AS nactacompleta
                 FROM w83b16s00 actas,
                      j7301s01 centros,
                      w83b13s00 convenios,
                      w83b24s00 escrutinios,
                      w83b19s00 sindicatos
                WHERE actas.id_centro_016 = centros.ccen_001
                  AND actas.c_conv_016 = convenios.c_conv_013(+)
                  AND actas.n_acta_016 = escrutinios.n_acta_024
                  AND actas.ano_acta_016 = escrutinios.ano_acta_024
                  AND actas.c_territ_016 = escrutinios.c_territ_024
                  AND actas.version_016 = escrutinios.version_024
                  AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019(+)
                  AND actas.n_regdef_016 IS NOT NULL
                  AND actas.n_acttot_016 IS NULL
                  AND actas.validada_016 = 1
             GROUP BY actas.n_acta_016,
                      actas.c_territ_016,
                      actas.ano_acta_016,
                      actas.version_016,
                      actas.ano_regdef_016,
                      actas.n_regdef_016,
                      actas.f_elecc_016,
                      actas.c_conv_016,
                      centros.ccif_001,
                      centros.secc_001,
                      centros.rsoc_001,
                      centros.ncen_001,
                      convenios.desc_013,
                      actas.totelec_016,
                      escrutinios.c_sindi_024,
                      sindicatos.desc_019,
                      sindicatos.siglas_019,
                      sindicatos.c_sindi_019,
                      actas.n_acttot_016,
                      actas.f_baja_016,
                      actas.fregdef_016,
                      TO_NUMBER (   actas.c_territ_016
                                 || actas.ano_acta_016
                                 || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                            1,  '00000'
                                             || TO_CHAR (actas.n_acta_016),
                                            2,  '0000'
                                             || TO_CHAR (actas.n_acta_016),
                                            3,  '000'
                                             || TO_CHAR (actas.n_acta_016),
                                            4, '00'
                                             || TO_CHAR (actas.n_acta_016),
                                            5, '0'
                                             || TO_CHAR (actas.n_acta_016),
                                            TO_CHAR (actas.n_acta_016)
                                           )
                                 || actas.version_016
                                )
             UNION ALL
             SELECT   actas.n_acta_016 AS nacta, actas.c_territ_016 AS territ,
                      actas.ano_acta_016 AS anoacta, actas.version_016 AS ver,
                      actas.ano_regdef_016 AS anoregdef,
                      actas.n_regdef_016 AS nregdef,
                      actas.f_elecc_016 AS felec, centros.ccif_001 AS cif,
                      centros.secc_001 AS sector, centros.rsoc_001 AS razon,
                      centros.ncen_001 AS ncentro,
                      convenios.desc_013 AS convdesc,
                      actas.totelec_016 AS totalelectores,
                      SUM (diferencias.n_delh_018 + diferencias.n_delm_018
                          ) AS numdelegados,
                      sindicatos.desc_019 AS sinddesc,
                      sindicatos.siglas_019 AS siglas,
                      sindicatos.c_sindi_019 AS codsindicato,
                      actas.n_acttot_016 AS actatotal,
                      actas.f_baja_016 AS fechabaja,
                      actas.fregdef_016 AS fecharegistro,
                      TO_NUMBER
                         (   actas.c_territ_016
                          || actas.ano_acta_016
                          || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                     1, '00000' || TO_CHAR (actas.n_acta_016),
                                     2, '0000' || TO_CHAR (actas.n_acta_016),
                                     3, '000' || TO_CHAR (actas.n_acta_016),
                                     4, '00' || TO_CHAR (actas.n_acta_016),
                                     5, '0' || TO_CHAR (actas.n_acta_016),
                                     TO_CHAR (actas.n_acta_016)
                                    )
                          || actas.version_016
                         ) AS nactacompleta
                 FROM w83b16s00 actas,
                      j7301s01 centros,
                      w83b13s00 convenios,
                      w83b18s00 diferencias,
                      w83b19s00 sindicatos
                WHERE actas.id_centro_016 = centros.ccen_001
                  AND actas.c_conv_016 = convenios.c_conv_013(+)
                  AND actas.n_acta_016 = diferencias.n_acta_018
                  AND actas.ano_acta_016 = diferencias.ano_acta_018
                  AND actas.c_territ_016 = diferencias.c_territ_018
                  AND actas.version_016 = diferencias.version_018
                  AND diferencias.c_sindi_018 = sindicatos.c_sindi_019(+)
                  AND actas.n_regdef_016 IS NOT NULL
                  AND actas.n_acttot_016 IS NULL
                  AND actas.validada_016 = 1
             GROUP BY actas.n_acta_016,
                      actas.c_territ_016,
                      actas.ano_acta_016,
                      actas.version_016,
                      actas.ano_regdef_016,
                      actas.n_regdef_016,
                      actas.f_elecc_016,
                      actas.c_conv_016,
                      centros.ccif_001,
                      centros.secc_001,
                      centros.rsoc_001,
                      centros.ncen_001,
                      convenios.desc_013,
                      actas.totelec_016,
                      diferencias.c_sindi_018,
                      sindicatos.desc_019,
                      sindicatos.siglas_019,
                      sindicatos.c_sindi_019,
                      actas.n_acttot_016,
                      actas.f_baja_016,
                      actas.fregdef_016,
                      TO_NUMBER (   actas.c_territ_016
                                 || actas.ano_acta_016
                                 || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                            1,  '00000'
                                             || TO_CHAR (actas.n_acta_016),
                                            2,  '0000'
                                             || TO_CHAR (actas.n_acta_016),
                                            3,  '000'
                                             || TO_CHAR (actas.n_acta_016),
                                            4, '00'
                                             || TO_CHAR (actas.n_acta_016),
                                            5, '0'
                                             || TO_CHAR (actas.n_acta_016),
                                            TO_CHAR (actas.n_acta_016)
                                           )
                                 || actas.version_016
                                )) consulta
      WHERE consulta.ver =
               (SELECT MAX (version_016)
                  FROM w83b16s00 act
                 WHERE consulta.nacta = act.n_acta_016
                   AND consulta.anoacta = act.ano_acta_016
                   AND consulta.territ = c_territ_016
                   AND act.validada_016 = 1
                   AND act.n_acttot_016 IS NULL)
   ORDER BY consulta.nacta ASC,
            consulta.anoacta ASC,
            consulta.territ ASC,
            consulta.codsindicato ASC;
/
CREATE OR REPLACE FORCE VIEW w83b.w83bdetallecentrosindicatohist (nacta,
                                                                  territ,
                                                                  anoacta,
                                                                  ver,
                                                                  anoregdef,
                                                                  nregdef,
                                                                  felec,
                                                                  cif,
                                                                  sector,
                                                                  razon,
                                                                  ncentro,
                                                                  convdesc,
                                                                  totalelectores,
                                                                  numdelegados,
                                                                  sinddesc,
                                                                  siglas,
                                                                  codsindicato,
                                                                  actatotal,
                                                                  fechabaja,
                                                                  fecharegistro,
                                                                  nactacompleta,
                                                                  fechaactu
                                                                 )
AS
   SELECT   consulta.nacta, consulta.territ, consulta.anoacta, consulta.ver,
            consulta.anoregdef, consulta.nregdef, consulta.felec,
            consulta.cif, consulta.sector, consulta.razon, consulta.ncentro,
            consulta.convdesc, consulta.totalelectores, consulta.numdelegados,
            consulta.sinddesc, consulta.siglas, consulta.codsindicato,
            consulta.actatotal, consulta.fechabaja, consulta.fecharegistro,
            consulta.nactacompleta, consulta.fechaactu
       FROM (SELECT   actas.n_acta_016 AS nacta, actas.c_territ_016 AS territ,
                      actas.ano_acta_016 AS anoacta, actas.version_016 AS ver,
                      actas.ano_regdef_016 AS anoregdef,
                      actas.n_regdef_016 AS nregdef,
                      actas.f_elecc_016 AS felec, centros.ccif_001 AS cif,
                      centros.secc_001 AS sector, centros.rsoc_001 AS razon,
                      centros.ncen_001 AS ncentro,
                      convenios.desc_013 AS convdesc,
                      actas.totelec_016 AS totalelectores,
                      SUM (escrutinios.n_delh_024 + escrutinios.n_delm_024
                          ) AS numdelegados,
                      sindicatos.desc_019 AS sinddesc,
                      sindicatos.siglas_019 AS siglas,
                      sindicatos.c_sindi_019 AS codsindicato,
                      actas.n_acttot_016 AS actatotal,
                      actas.f_baja_016 AS fechabaja,
                      actas.fregdef_016 AS fecharegistro,
                      TO_NUMBER
                         (   actas.c_territ_016
                          || actas.ano_acta_016
                          || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                     1, '00000' || TO_CHAR (actas.n_acta_016),
                                     2, '0000' || TO_CHAR (actas.n_acta_016),
                                     3, '000' || TO_CHAR (actas.n_acta_016),
                                     4, '00' || TO_CHAR (actas.n_acta_016),
                                     5, '0' || TO_CHAR (actas.n_acta_016),
                                     TO_CHAR (actas.n_acta_016)
                                    )
                          || actas.version_016
                         ) AS nactacompleta,
                      actas.factu_016 AS fechaactu
                 FROM w83b16s00 actas,
                      j7301s01 centros,
                      w83b13s00 convenios,
                      w83b24s00 escrutinios,
                      w83b19s00 sindicatos
                WHERE actas.id_centro_016 = centros.ccen_001
                  AND actas.c_conv_016 = convenios.c_conv_013(+)
                  AND actas.n_acta_016 = escrutinios.n_acta_024
                  AND actas.ano_acta_016 = escrutinios.ano_acta_024
                  AND actas.c_territ_016 = escrutinios.c_territ_024
                  AND actas.version_016 = escrutinios.version_024
                  AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019(+)
                  AND actas.n_regdef_016 IS NOT NULL
                  AND actas.n_acttot_016 IS NULL
                  AND actas.validada_016 = 1
             GROUP BY actas.n_acta_016,
                      actas.c_territ_016,
                      actas.ano_acta_016,
                      actas.version_016,
                      actas.ano_regdef_016,
                      actas.n_regdef_016,
                      actas.f_elecc_016,
                      actas.c_conv_016,
                      centros.ccif_001,
                      centros.secc_001,
                      centros.rsoc_001,
                      centros.ncen_001,
                      convenios.desc_013,
                      actas.totelec_016,
                      escrutinios.c_sindi_024,
                      sindicatos.desc_019,
                      sindicatos.siglas_019,
                      sindicatos.c_sindi_019,
                      actas.n_acttot_016,
                      actas.f_baja_016,
                      actas.fregdef_016,
                      TO_NUMBER (   actas.c_territ_016
                                 || actas.ano_acta_016
                                 || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                            1,  '00000'
                                             || TO_CHAR (actas.n_acta_016),
                                            2,  '0000'
                                             || TO_CHAR (actas.n_acta_016),
                                            3,  '000'
                                             || TO_CHAR (actas.n_acta_016),
                                            4, '00'
                                             || TO_CHAR (actas.n_acta_016),
                                            5, '0'
                                             || TO_CHAR (actas.n_acta_016),
                                            TO_CHAR (actas.n_acta_016)
                                           )
                                 || actas.version_016
                                ),
                      actas.factu_016
             UNION ALL
             SELECT   actas.n_acta_016 AS nacta, actas.c_territ_016 AS territ,
                      actas.ano_acta_016 AS anoacta, actas.version_016 AS ver,
                      actas.ano_regdef_016 AS anoregdef,
                      actas.n_regdef_016 AS nregdef,
                      actas.f_elecc_016 AS felec, centros.ccif_001 AS cif,
                      centros.secc_001 AS sector, centros.rsoc_001 AS razon,
                      centros.ncen_001 AS ncentro,
                      convenios.desc_013 AS convdesc,
                      actas.totelec_016 AS totalelectores,
                      SUM (diferencias.n_delh_018 + diferencias.n_delm_018
                          ) AS numdelegados,
                      sindicatos.desc_019 AS sinddesc,
                      sindicatos.siglas_019 AS siglas,
                      sindicatos.c_sindi_019 AS codsindicato,
                      actas.n_acttot_016 AS actatotal,
                      actas.f_baja_016 AS fechabaja,
                      actas.fregdef_016 AS fecharegistro,
                      TO_NUMBER
                         (   actas.c_territ_016
                          || actas.ano_acta_016
                          || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                     1, '00000' || TO_CHAR (actas.n_acta_016),
                                     2, '0000' || TO_CHAR (actas.n_acta_016),
                                     3, '000' || TO_CHAR (actas.n_acta_016),
                                     4, '00' || TO_CHAR (actas.n_acta_016),
                                     5, '0' || TO_CHAR (actas.n_acta_016),
                                     TO_CHAR (actas.n_acta_016)
                                    )
                          || actas.version_016
                         ) AS nactacompleta,
                      actas.factu_016 AS fechaactu
                 FROM w83b16s00 actas,
                      j7301s01 centros,
                      w83b13s00 convenios,
                      w83b18s00 diferencias,
                      w83b19s00 sindicatos
                WHERE actas.id_centro_016 = centros.ccen_001
                  AND actas.c_conv_016 = convenios.c_conv_013(+)
                  AND actas.n_acta_016 = diferencias.n_acta_018
                  AND actas.ano_acta_016 = diferencias.ano_acta_018
                  AND actas.c_territ_016 = diferencias.c_territ_018
                  AND actas.version_016 = diferencias.version_018
                  AND diferencias.c_sindi_018 = sindicatos.c_sindi_019(+)
                  AND actas.n_regdef_016 IS NOT NULL
                  AND actas.n_acttot_016 IS NULL
                  AND actas.validada_016 = 1
             GROUP BY actas.n_acta_016,
                      actas.c_territ_016,
                      actas.ano_acta_016,
                      actas.version_016,
                      actas.ano_regdef_016,
                      actas.n_regdef_016,
                      actas.f_elecc_016,
                      actas.c_conv_016,
                      centros.ccif_001,
                      centros.secc_001,
                      centros.rsoc_001,
                      centros.ncen_001,
                      convenios.desc_013,
                      actas.totelec_016,
                      diferencias.c_sindi_018,
                      sindicatos.desc_019,
                      sindicatos.siglas_019,
                      sindicatos.c_sindi_019,
                      actas.n_acttot_016,
                      actas.f_baja_016,
                      actas.fregdef_016,
                      TO_NUMBER (   actas.c_territ_016
                                 || actas.ano_acta_016
                                 || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                            1,  '00000'
                                             || TO_CHAR (actas.n_acta_016),
                                            2,  '0000'
                                             || TO_CHAR (actas.n_acta_016),
                                            3,  '000'
                                             || TO_CHAR (actas.n_acta_016),
                                            4, '00'
                                             || TO_CHAR (actas.n_acta_016),
                                            5, '0'
                                             || TO_CHAR (actas.n_acta_016),
                                            TO_CHAR (actas.n_acta_016)
                                           )
                                 || actas.version_016
                                ),
                      actas.factu_016) consulta
   ORDER BY consulta.nacta ASC,
            consulta.anoacta ASC,
            consulta.territ ASC,
            consulta.codsindicato ASC;
/
CREATE OR REPLACE FORCE VIEW w83b.w83bescrutiniosporconvenio (nregistro,
                                                              codprovincia,
                                                              codmunicipio,
                                                              codcnae,
                                                              nacta,
                                                              nactacompleta,
                                                              territ,
                                                              totalelectores,
                                                              codconvenio,
                                                              descconvenio,
                                                              deseconvenio,
                                                              adminemp,
                                                              codcolegio,
                                                              codsindicato,
                                                              siglas,
                                                              numdelegados,
                                                              votos,
                                                              felec,
                                                              fecharegistro,
                                                              fechabaja
                                                             )
AS
   SELECT    consulta.territ
          || '/'
          || consulta.anoreg
          || '/'
          || DECODE (LENGTH (TO_CHAR (consulta.nreg)),
                     1, '00000' || TO_CHAR (consulta.nreg),
                     2, '0000' || TO_CHAR (consulta.nreg),
                     3, '000' || TO_CHAR (consulta.nreg),
                     4, '00' || TO_CHAR (consulta.nreg),
                     5, '0' || TO_CHAR (consulta.nreg),
                     TO_CHAR (consulta.nreg)
                    ),
          consulta.codprovincia, consulta.codmunicipio, consulta.codcnae,
             consulta.territ
          || '/'
          || consulta.anoacta
          || '/'
          || DECODE (LENGTH (TO_CHAR (consulta.nacta)),
                     1, '00000' || TO_CHAR (consulta.nacta),
                     2, '0000' || TO_CHAR (consulta.nacta),
                     3, '000' || TO_CHAR (consulta.nacta),
                     4, '00' || TO_CHAR (consulta.nacta),
                     5, '0' || TO_CHAR (consulta.nacta),
                     TO_CHAR (consulta.nacta)
                    ),
          TO_NUMBER (   consulta.anoacta
                     || DECODE (LENGTH (TO_CHAR (consulta.nacta)),
                                1, '00000' || TO_CHAR (consulta.nacta),
                                2, '0000' || TO_CHAR (consulta.nacta),
                                3, '000' || TO_CHAR (consulta.nacta),
                                4, '00' || TO_CHAR (consulta.nacta),
                                5, '0' || TO_CHAR (consulta.nacta),
                                TO_CHAR (consulta.nacta)
                               )
                    ),
          consulta.territ, consulta.numtrabajadores, consulta.codconvenio,
          consulta.descconvenio, consulta.deseconvenio, consulta.adminemp,
          consulta.codcolegio, consulta.codsindicato, consulta.siglas,
          consulta.delegadosescrutiniosh + consulta.delegadosescrutiniosm,
          consulta.votos, consulta.fechaeleccion, consulta.fecharegistro,
          consulta.fbaja
     FROM (SELECT   actas.totelec_016 AS numtrabajadores,
                    centros.provc_001 AS codprovincia,
                    centros.munic_001 AS codmunicipio,
                    centros.cnae_001 AS codcnae,
                    actas.ano_regdef_016 AS anoreg,
                    actas.n_regdef_016 AS nreg, actas.n_acta_016 AS nacta,
                    actas.ano_acta_016 AS anoacta,
                    actas.c_territ_016 AS territ, actas.version_016 AS ver,
                    actas.f_elecc_016 AS fechaeleccion,
                    actas.fregdef_016 AS fecharegistro,
                    actas.f_baja_016 AS fbaja,
                    actas.c_conv_016 AS codconvenio,
                    convenios.desc_013 AS descconvenio,
                    convenios.dese_013 AS deseconvenio,
                    CASE
                       WHEN (escrutinios.c_coleg_024 = '0')
                          THEN 'T'
                       WHEN (escrutinios.c_coleg_024 = '1')
                          THEN 'E'
                       ELSE ''
                    END AS codcolegio,
                    escrutinios.c_sindi_024 AS codsindicato,
                    sindicatos.siglas_019 AS siglas,
                    CASE
                       WHEN (preavisos.admonemp_037 = 'A')
                          THEN 'S'
                       WHEN (preavisos.admonemp_037 = 'E')
                          THEN 'N'
                       ELSE ''
                    END AS adminemp,
                    COALESCE
                            (escrutinios.n_delh_024,
                             0
                            ) AS delegadosescrutiniosh,
                    COALESCE
                            (escrutinios.n_delm_024,
                             0
                            ) AS delegadosescrutiniosm,
                     /*escrutinios.n_votos_024 AS votos,*/
                    SUM (papeletas.vota_044) AS votos
               FROM w83b16s00 actas,
                    w83b37s00 preavisos,
                    j7301s01 centros,
                    w83b24s00 escrutinios,
                    w83b13s00 convenios,
                    w83b19s00 sindicatos,
                    w83b44s00 papeletas
              WHERE centros.ccen_001 = actas.id_centro_016
                AND actas.n_acta_016 = escrutinios.n_acta_024
                AND actas.ano_acta_016 = escrutinios.ano_acta_024
                AND actas.c_territ_016 = escrutinios.c_territ_024
                AND actas.version_016 = escrutinios.version_024
                AND escrutinios.n_acta_024 = papeletas.n_acta_044(+)
                AND escrutinios.ano_acta_024 = papeletas.ano_acta_044(+)
                AND escrutinios.c_territ_024 = papeletas.c_territ_044(+)
                AND escrutinios.version_024 = papeletas.version_044(+)
                AND escrutinios.c_coleg_024 = papeletas.c_coleg_044(+)
                AND actas.n_preaviso_016 = preavisos.n_preaviso_037(+)
                AND actas.ano_preaviso_016 = preavisos.ano_preaviso_037(+)
                AND actas.c_territ_016 = preavisos.c_territ_037(+)
                AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019(+)
                AND actas.c_conv_016 = convenios.c_conv_013(+)
                AND actas.n_regdef_016 IS NOT NULL
                AND actas.fregdef_016 IS NOT NULL
                AND actas.n_acttot_016 IS NULL
                AND actas.validada_016 = 1
           GROUP BY actas.totelec_016,
                    centros.provc_001,
                    centros.munic_001,
                    centros.cnae_001,
                    actas.ano_regdef_016,
                    actas.n_regdef_016,
                    actas.n_acta_016,
                    actas.ano_acta_016,
                    actas.c_territ_016,
                    actas.version_016,
                    actas.f_elecc_016,
                    actas.fregdef_016,
                    actas.f_baja_016,
                    actas.c_conv_016,
                    convenios.desc_013,
                    convenios.dese_013,
                    escrutinios.c_coleg_024,
                    escrutinios.c_sindi_024,
                    sindicatos.siglas_019,
                    preavisos.admonemp_037,
                    escrutinios.n_votos_024,
                    escrutinios.n_delh_024,
                    escrutinios.n_delm_024,
                    papeletas.vota_044) consulta
    WHERE consulta.ver =
             (SELECT MAX (version_016)
                FROM w83b16s00 actas
               WHERE consulta.nacta = actas.n_acta_016
                 AND consulta.anoacta = actas.ano_acta_016
                 AND consulta.territ = c_territ_016
                 AND actas.validada_016 = 1);
/
CREATE OR REPLACE FORCE VIEW w83b.w83bescrutiniosporconveniohist (nregistro,
                                                                  codprovincia,
                                                                  codmunicipio,
                                                                  codcnae,
                                                                  nacta,
                                                                  acta,
                                                                  ano,
                                                                  nactacompleta,
                                                                  territ,
                                                                  totalelectores,
                                                                  codconvenio,
                                                                  descconvenio,
                                                                  deseconvenio,
                                                                  adminemp,
                                                                  codcolegio,
                                                                  codsindicato,
                                                                  siglas,
                                                                  numdelegados,
                                                                  votos,
                                                                  felec,
                                                                  fecharegistro,
                                                                  fechabaja,
                                                                  fechaactu,
                                                                  ver
                                                                 )
AS
   SELECT    consulta.territ
          || '/'
          || consulta.anoreg
          || '/'
          || DECODE (LENGTH (TO_CHAR (consulta.nreg)),
                     1, '00000' || TO_CHAR (consulta.nreg),
                     2, '0000' || TO_CHAR (consulta.nreg),
                     3, '000' || TO_CHAR (consulta.nreg),
                     4, '00' || TO_CHAR (consulta.nreg),
                     5, '0' || TO_CHAR (consulta.nreg),
                     TO_CHAR (consulta.nreg)
                    ),
          consulta.codprovincia, consulta.codmunicipio, consulta.codcnae,
             consulta.territ
          || '/'
          || consulta.anoacta
          || '/'
          || DECODE (LENGTH (TO_CHAR (consulta.nacta)),
                     1, '00000' || TO_CHAR (consulta.nacta),
                     2, '0000' || TO_CHAR (consulta.nacta),
                     3, '000' || TO_CHAR (consulta.nacta),
                     4, '00' || TO_CHAR (consulta.nacta),
                     5, '0' || TO_CHAR (consulta.nacta),
                     TO_CHAR (consulta.nacta)
                    ),
          consulta.acta, consulta.ano,
          TO_NUMBER (   consulta.anoacta
                     || DECODE (LENGTH (TO_CHAR (consulta.nacta)),
                                1, '00000' || TO_CHAR (consulta.nacta),
                                2, '0000' || TO_CHAR (consulta.nacta),
                                3, '000' || TO_CHAR (consulta.nacta),
                                4, '00' || TO_CHAR (consulta.nacta),
                                5, '0' || TO_CHAR (consulta.nacta),
                                TO_CHAR (consulta.nacta)
                               )
                    ),
          consulta.territ, consulta.numtrabajadores, consulta.codconvenio,
          consulta.descconvenio, consulta.deseconvenio, consulta.adminemp,
          consulta.codcolegio, consulta.codsindicato, consulta.siglas,
          consulta.delegadosescrutiniosh + consulta.delegadosescrutiniosm,
          consulta.votos, consulta.fechaeleccion, consulta.fecharegistro,
          consulta.fbaja, consulta.fechaactu, consulta.ver
     FROM (SELECT   actas.totelec_016 AS numtrabajadores,
                    centros.provc_001 AS codprovincia,
                    centros.munic_001 AS codmunicipio,
                    centros.cnae_001 AS codcnae,
                    actas.ano_regdef_016 AS anoreg,
                    actas.n_regdef_016 AS nreg, actas.n_acta_016 AS nacta,
                    actas.ano_acta_016 AS ano, actas.n_acta_016 AS acta,
                    actas.c_territ_016 AS territ, actas.version_016 AS ver,
                    actas.f_elecc_016 AS fechaeleccion,
                    actas.fregdef_016 AS fecharegistro,
                    actas.f_baja_016 AS fbaja, actas.factu_016 AS fechaactu,
                    actas.version_016, actas.c_conv_016 AS codconvenio,
                    actas.ano_acta_016 AS anoacta,
                    convenios.desc_013 AS descconvenio,
                    convenios.dese_013 AS deseconvenio,
                    CASE
                       WHEN (escrutinios.c_coleg_024 = '0')
                          THEN 'T'
                       WHEN (escrutinios.c_coleg_024 = '1')
                          THEN 'E'
                       ELSE ''
                    END AS codcolegio,
                    escrutinios.c_sindi_024 AS codsindicato,
                    sindicatos.siglas_019 AS siglas,
                    CASE
                       WHEN (preavisos.admonemp_037 = 'A')
                          THEN 'S'
                       WHEN (preavisos.admonemp_037 = 'E')
                          THEN 'N'
                       ELSE ''
                    END AS adminemp,
                    COALESCE
                            (escrutinios.n_delh_024,
                             0
                            ) AS delegadosescrutiniosh,
                    COALESCE
                            (escrutinios.n_delm_024,
                             0
                            ) AS delegadosescrutiniosm,
                    SUM (papeletas.vota_044) AS votos
               FROM w83b16s00 actas,
                    w83b37s00 preavisos,
                    j7301s01 centros,
                    w83b24s00 escrutinios,
                    w83b13s00 convenios,
                    w83b19s00 sindicatos,
                    w83b44s00 papeletas
              WHERE centros.ccen_001 = actas.id_centro_016
                AND actas.n_acta_016 = escrutinios.n_acta_024
                AND actas.ano_acta_016 = escrutinios.ano_acta_024
                AND actas.c_territ_016 = escrutinios.c_territ_024
                AND actas.version_016 = escrutinios.version_024
                AND escrutinios.n_acta_024 = papeletas.n_acta_044(+)
                AND escrutinios.ano_acta_024 = papeletas.ano_acta_044(+)
                AND escrutinios.c_territ_024 = papeletas.c_territ_044(+)
                AND escrutinios.version_024 = papeletas.version_044(+)
                AND escrutinios.c_coleg_024 = papeletas.c_coleg_044(+)
                AND actas.n_preaviso_016 = preavisos.n_preaviso_037(+)
                AND actas.ano_preaviso_016 = preavisos.ano_preaviso_037(+)
                AND actas.c_territ_016 = preavisos.c_territ_037(+)
                AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019(+)
                AND actas.c_conv_016 = convenios.c_conv_013(+)
                AND actas.n_regdef_016 IS NOT NULL
                AND actas.fregdef_016 IS NOT NULL
                AND actas.n_acttot_016 IS NULL
                AND actas.validada_016 = 1
           GROUP BY actas.totelec_016,
                    centros.provc_001,
                    centros.munic_001,
                    centros.cnae_001,
                    actas.ano_regdef_016,
                    actas.n_regdef_016,
                    actas.n_acta_016,
                    actas.ano_acta_016,
                    actas.ano_acta_016,
                    actas.c_territ_016,
                    actas.version_016,
                    actas.f_elecc_016,
                    actas.fregdef_016,
                    actas.f_baja_016,
                    actas.factu_016,
                    actas.c_conv_016,
                    convenios.desc_013,
                    convenios.dese_013,
                    escrutinios.c_coleg_024,
                    escrutinios.c_sindi_024,
                    sindicatos.siglas_019,
                    preavisos.admonemp_037,
                    escrutinios.n_votos_024,
                    escrutinios.n_delh_024,
                    escrutinios.n_delm_024,
                    papeletas.vota_044) consulta;
/
CREATE OR REPLACE FORCE VIEW w83b.w83bresultadosporsexoinc (nacta,
                                                            territ,
                                                            anoacta,
                                                            ver,
                                                            felec,
                                                            electoresh,
                                                            electoresm,
                                                            totalelectores,
                                                            ncandidatosh,
                                                            ncandidatosm,
                                                            sumdelegadosh,
                                                            sumdelegadosm,
                                                            sumdelegados,
                                                            fechabaja,
                                                            fecharegistro,
                                                            fechaactualizacion,
                                                            fechaelec,
                                                            nactacompleta,
                                                            dsprovincia
                                                           )
AS
   SELECT   actas.n_acta_016 AS nacta, actas.c_territ_016 AS territ,
            actas.ano_acta_016 AS anoacta, actas.version_016 AS ver,
            actas.f_elecc_016 AS felec, actas.elech_016 AS electoresh,
            actas.elecm_016 AS electoresm,
            actas.totelec_016 AS totalelectores,
            actas.candh_016 AS ncandidatosh, actas.candm_016 AS ncandidatosm,
            SUM (escrutinios.n_delh_024) AS delegadosh,
            SUM (escrutinios.n_delm_024) AS delegadosm,
            SUM (escrutinios.n_delh_024 + escrutinios.n_delm_024
                ) AS numdelegados,
            actas.f_baja_016 AS fechabaja, actas.fregdef_016 AS fecharegistro,
            actas.factu_016 AS fechaactualizacion,
            actas.f_elecc_016 AS fechaelec,
            TO_NUMBER
               (   actas.c_territ_016
                || actas.ano_acta_016
                || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                           1, '00000' || TO_CHAR (actas.n_acta_016),
                           2, '0000' || TO_CHAR (actas.n_acta_016),
                           3, '000' || TO_CHAR (actas.n_acta_016),
                           4, '00' || TO_CHAR (actas.n_acta_016),
                           5, '0' || TO_CHAR (actas.n_acta_016),
                           TO_CHAR (actas.n_acta_016)
                          )
                || actas.version_016
               ) AS nactacompleta,
            prov.ds_o AS dsprovincia
       FROM w83b16s00 actas,
            j7301s01 centros,
            w83b13s00 convenios,
            w83b24s00 escrutinios,
            w83b19s00 sindicatos,
            t17i.t17_provincia prov
      WHERE actas.id_centro_016 = centros.ccen_001
        AND actas.c_conv_016 = convenios.c_conv_013(+)
        AND actas.n_acta_016 = escrutinios.n_acta_024
        AND actas.ano_acta_016 = escrutinios.ano_acta_024
        AND actas.c_territ_016 = escrutinios.c_territ_024
        AND actas.version_016 = escrutinios.version_024
        AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019(+)
        AND actas.n_regdef_016 IS NOT NULL
        AND actas.n_acttot_016 IS NULL
        AND actas.validada_016 = 1
        AND actas.c_territ_016 = prov.ID
   GROUP BY actas.n_acta_016,
            actas.c_territ_016,
            actas.ano_acta_016,
            actas.version_016,
            actas.f_elecc_016,
            actas.elech_016,
            actas.elecm_016,
            actas.totelec_016,
            actas.candh_016,
            actas.candm_016,
            escrutinios.n_delh_024,
            escrutinios.n_delm_024,
            actas.f_baja_016,
            actas.fregdef_016,
            actas.factu_016,
            actas.f_elecc_016,
            TO_NUMBER (   actas.c_territ_016
                       || actas.ano_acta_016
                       || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                  1, '00000' || TO_CHAR (actas.n_acta_016),
                                  2, '0000' || TO_CHAR (actas.n_acta_016),
                                  3, '000' || TO_CHAR (actas.n_acta_016),
                                  4, '00' || TO_CHAR (actas.n_acta_016),
                                  5, '0' || TO_CHAR (actas.n_acta_016),
                                  TO_CHAR (actas.n_acta_016)
                                 )
                       || actas.version_016
                      ),
            prov.ds_o;
/
CREATE OR REPLACE FORCE VIEW w83b.w83bvistaimpugsimple (nimpugnacion,
                                                        npreaviso,
                                                        nacta,
                                                        anyoimpugnacion,
                                                        numimpugnacion,
                                                        codterritorioimpugnacion,
                                                        anyopreaviso,
                                                        numpreaviso,
                                                        anyoacta,
                                                        numacta,
                                                        VERSION,
                                                        anyolaudo,
                                                        numlaudo,
                                                        fimpugnaciondate,
                                                        arbitro,
                                                        nomarbitro,
                                                        fenvioarbitrodate,
                                                        fenviojuzgadodate,
                                                        fsentenciadate,
                                                        tipoimpug,
                                                        desctipoimpug,
                                                        desetipoimpug,
                                                        asunto,
                                                        decision,
                                                        nlaudo,
                                                        flaudodate,
                                                        fdesestimientodate,
                                                        resultado,
                                                        descresultado,
                                                        deseresultado,
                                                        idcentro,
                                                        nregistro,
                                                        fregistrodate,
                                                        dniimpug,
                                                        nombreimpug,
                                                        dirimpug,
                                                        cpimpug,
                                                        muniimpug,
                                                        provimpug,
                                                        citacion,
                                                        codvoces,
                                                        descvoces,
                                                        desevoces,
                                                        codsindicatos,
                                                        descsindicatos,
                                                        desesindicatos,
                                                        nimpugnacionesint,
                                                        npreavisosint,
                                                        nactasint,
                                                        nlaudosint,
                                                        abrsindicatos
                                                       )
AS
   SELECT      w83b_33s00.c_territ_033
            || '/'
            || w83b_33s00.ano_impug_033
            || '/'
            || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_impug_033)),
                       1, '00000' || TO_CHAR (w83b_33s00.n_impug_033),
                       2, '0000' || TO_CHAR (w83b_33s00.n_impug_033),
                       3, '000' || TO_CHAR (w83b_33s00.n_impug_033),
                       4, '00' || TO_CHAR (w83b_33s00.n_impug_033),
                       5, '0' || TO_CHAR (w83b_33s00.n_impug_033),
                       TO_CHAR (w83b_33s00.n_impug_033)
                      ),
               w83b_33s00.c_territ_033
            || '/'
            || w83b_33s00.ano_preaviso_033
            || '/'
            || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_preaviso_033)),
                       1, '00000' || TO_CHAR (w83b_33s00.n_preaviso_033),
                       2, '0000' || TO_CHAR (w83b_33s00.n_preaviso_033),
                       3, '000' || TO_CHAR (w83b_33s00.n_preaviso_033),
                       4, '00' || TO_CHAR (w83b_33s00.n_preaviso_033),
                       5, '0' || TO_CHAR (w83b_33s00.n_preaviso_033),
                       TO_CHAR (w83b_33s00.n_preaviso_033)
                      ),
               w83b_33s00.c_territ_033
            || '/'
            || w83b_33s00.ano_acta_033
            || '/'
            || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_acta_033)),
                       1, '00000' || TO_CHAR (w83b_33s00.n_acta_033),
                       2, '0000' || TO_CHAR (w83b_33s00.n_acta_033),
                       3, '000' || TO_CHAR (w83b_33s00.n_acta_033),
                       4, '00' || TO_CHAR (w83b_33s00.n_acta_033),
                       5, '0' || TO_CHAR (w83b_33s00.n_acta_033),
                       TO_CHAR (w83b_33s00.n_acta_033)
                      ),
            w83b_33s00.ano_impug_033,
            DECODE (LENGTH (TO_CHAR (w83b_33s00.n_impug_033)),
                    1, '00000' || TO_CHAR (w83b_33s00.n_impug_033),
                    2, '0000' || TO_CHAR (w83b_33s00.n_impug_033),
                    3, '000' || TO_CHAR (w83b_33s00.n_impug_033),
                    4, '00' || TO_CHAR (w83b_33s00.n_impug_033),
                    5, '0' || TO_CHAR (w83b_33s00.n_impug_033),
                    TO_CHAR (w83b_33s00.n_impug_033)
                   ),
            w83b_33s00.c_territ_033, w83b_33s00.ano_preaviso_033,
            DECODE (LENGTH (TO_CHAR (w83b_33s00.n_preaviso_033)),
                    1, '00000' || TO_CHAR (w83b_33s00.n_preaviso_033),
                    2, '0000' || TO_CHAR (w83b_33s00.n_preaviso_033),
                    3, '000' || TO_CHAR (w83b_33s00.n_preaviso_033),
                    4, '00' || TO_CHAR (w83b_33s00.n_preaviso_033),
                    5, '0' || TO_CHAR (w83b_33s00.n_preaviso_033),
                    TO_CHAR (w83b_33s00.n_preaviso_033)
                   ),
            w83b_33s00.ano_acta_033,
            DECODE (LENGTH (TO_CHAR (w83b_33s00.n_acta_033)),
                    1, '00000' || TO_CHAR (w83b_33s00.n_acta_033),
                    2, '0000' || TO_CHAR (w83b_33s00.n_acta_033),
                    3, '000' || TO_CHAR (w83b_33s00.n_acta_033),
                    4, '00' || TO_CHAR (w83b_33s00.n_acta_033),
                    5, '0' || TO_CHAR (w83b_33s00.n_acta_033),
                    TO_CHAR (w83b_33s00.n_acta_033)
                   ),
            w83b_33s00.version_033, w83b_68s00.ano_laudo_068,
            DECODE (LENGTH (TO_CHAR (w83b_68s00.n_laudo_068)),
                    1, '00' || TO_CHAR (w83b_68s00.n_laudo_068),
                    2, '0' || TO_CHAR (w83b_68s00.n_laudo_068),
                    TO_CHAR (w83b_68s00.n_laudo_068)
                   ),
            w83b_33s00.f_impug_033, w83b_33s00.dni_033, w83b_36s00.nombre_036,
            w83b_33s00.fenvarb_033, w83b_33s00.fenvjuz_033,
            w83b_33s00.f_senten_033, w83b_33s00.c_impug_033,
            w83b_30s00.desc_030, w83b_30s00.dese_030, w83b_33s00.asunto_033,
            w83b_33s00.decisiob_033,
               w83b_33s00.c_territ_033
            || '/'
            || w83b_68s00.ano_laudo_068
            || '/'
            || DECODE (LENGTH (TO_CHAR (w83b_68s00.n_laudo_068)),
                       1, '00' || TO_CHAR (w83b_68s00.n_laudo_068),
                       2, '0' || TO_CHAR (w83b_68s00.n_laudo_068),
                       TO_CHAR (w83b_68s00.n_laudo_068)
                      ),
            w83b_68s00.flaudo_068, w83b_33s00.fdeses_033,
            w83b_68s00.rdo_laudo_068, w83b_75s00.desc_rdo_cas_075,
            w83b_75s00.desc_rdo_eus_075,
            CASE
               WHEN w83b_37s00.id_centro_037 IS NULL
                  THEN w83b_16s00.id_centro_016
               WHEN w83b_16s00.id_centro_016 IS NULL
                  THEN w83b_37s00.id_centro_037
               ELSE 0
            END AS idcentro,
            w83b_33s00.n_regis_033, w83b_33s00.f_regis_033,
            w83b_76s00.dni_imp_076, w83b_76s00.nombre_imp_076,
            w83b_76s00.dir_imp_076, w83b_76s00.codpos_imp_076,
            w83b_76s00.mun_imp_076, w83b_76s00.prov_imp_076,
            w83b_59s00.id_centro_059,
            stragg_int (DISTINCT (   w83b_31s00.ctipvoz_031
                                  || '|'
                                  || w83b_31s00.cvoz_031
                                  || '|'
                                  || w83b_34s00.sino_034
                         )
                       ),
            stragg_int (DISTINCT (   w83b_32s00.desc_032
                                  || '|'
                                  || w83b_31s00.desc_031
                                  || '@'
                                  || w83b_31s00.ctipvoz_031
                                  || '|'
                                  || w83b_31s00.cvoz_031
                                  || '|'
                                  || w83b_34s00.sino_034
                         )
                       ),
            stragg_int (DISTINCT (   w83b_32s00.dese_032
                                  || '|'
                                  || w83b_31s00.dese_031
                                  || '@'
                                  || w83b_31s00.ctipvoz_031
                                  || '|'
                                  || w83b_31s00.cvoz_031
                                  || '|'
                                  || w83b_34s00.sino_034
                         )
                       ),
            stragg_int (DISTINCT (w83b_19s00.c_sindi_019)),
            stragg_int (DISTINCT (   w83b_19s00.desc_019
                                  || '@'
                                  || w83b_19s00.c_sindi_019
                         )
                       ),
            stragg_int (DISTINCT (   w83b_19s00.dese_019
                                  || '@'
                                  || w83b_19s00.c_sindi_019
                         )
                       ),
            TO_NUMBER
               (   w83b_33s00.ano_impug_033
                || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_impug_033)),
                           1, '00000' || TO_CHAR (w83b_33s00.n_impug_033),
                           2, '0000' || TO_CHAR (w83b_33s00.n_impug_033),
                           3, '000' || TO_CHAR (w83b_33s00.n_impug_033),
                           4, '00' || TO_CHAR (w83b_33s00.n_impug_033),
                           5, '0' || TO_CHAR (w83b_33s00.n_impug_033),
                           TO_CHAR (w83b_33s00.n_impug_033)
                          )
               ) AS nimpugnacionesint,
            TO_NUMBER
               (   w83b_33s00.ano_preaviso_033
                || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_preaviso_033)),
                           1, '00000' || TO_CHAR (w83b_33s00.n_preaviso_033),
                           2, '0000' || TO_CHAR (w83b_33s00.n_preaviso_033),
                           3, '000' || TO_CHAR (w83b_33s00.n_preaviso_033),
                           4, '00' || TO_CHAR (w83b_33s00.n_preaviso_033),
                           5, '0' || TO_CHAR (w83b_33s00.n_preaviso_033),
                           TO_CHAR (w83b_33s00.n_preaviso_033)
                          )
               ) AS npreavisosint,
            TO_NUMBER
                (   w83b_33s00.ano_acta_033
                 || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_acta_033)),
                            1, '00000' || TO_CHAR (w83b_33s00.n_acta_033),
                            2, '0000' || TO_CHAR (w83b_33s00.n_acta_033),
                            3, '000' || TO_CHAR (w83b_33s00.n_acta_033),
                            4, '00' || TO_CHAR (w83b_33s00.n_acta_033),
                            5, '0' || TO_CHAR (w83b_33s00.n_acta_033),
                            TO_CHAR (w83b_33s00.n_acta_033)
                           )
                ) AS nactasint,
            TO_NUMBER
               (   w83b_68s00.ano_laudo_068
                || DECODE (LENGTH (TO_CHAR (w83b_68s00.n_laudo_068)),
                           1, '00' || TO_CHAR (w83b_68s00.n_laudo_068),
                           2, '0' || TO_CHAR (w83b_68s00.n_laudo_068),
                           TO_CHAR (w83b_68s00.n_laudo_068)
                          )
               ) AS nlaudosint,
            stragg_int (DISTINCT (w83b_19s00.siglas_019))
       FROM w83b33s00 w83b_33s00,
            w83b68s00 w83b_68s00,
            w83b30s00 w83b_30s00,
            w83b59s00 w83b_59s00,
            w83b75s00 w83b_75s00,
            w83b34s00 w83b_34s00,
            w83b31s00 w83b_31s00,
            w83b32s00 w83b_32s00,
            w83b37s00 w83b_37s00,
            w83b16s00 w83b_16s00,
            w83b76s00 w83b_76s00,
            w83b36s00 w83b_36s00,
            w83b35s00 w83b_35s00,
            w83b19s00 w83b_19s00
      WHERE c_impug_033 = c_impug_030
        AND c_territ_033 = c_territ_068(+)
        AND n_impug_033 = n_impug_068(+)
        AND ano_impug_033 = ano_impug_068(+)
        AND c_territ_033 = c_territ_059(+)
        AND n_impug_033 = num_impugnac_059(+)
        AND ano_impug_033 = ano_impugn_059(+)
        AND rdo_laudo_068 = id_rdo_075(+)
        AND c_territ_068 = c_territ_034(+)
        AND n_impug_068 = n_impug_034(+)
        AND ano_impug_068 = ano_impug_034(+)
        AND n_laudo_068 = n_laudo_034(+)
        AND ano_laudo_068 = ano_laudo_034(+)
        AND ctipvoz_034 = ctipvoz_031(+)
        AND cvoz_034 = cvoz_031(+)
        AND ctipvoz_031 = ctipvoz_032(+)
        AND c_territ_033 = c_territ_037(+)
        AND n_preaviso_033 = n_preaviso_037(+)
        AND ano_preaviso_033 = ano_preaviso_037(+)
        AND c_territ_033 = c_territ_016(+)
        AND n_acta_033 = n_acta_016(+)
        AND ano_acta_033 = ano_acta_016(+)
        AND version_033 = version_016(+)
        AND c_territ_033 = c_territ_076(+)
        AND n_impug_033 = n_impug_076(+)
        AND ano_impug_033 = ano_impug_076(+)
        AND dni_033 = dni_036(+)
        AND c_territ_033 = w83b_36s00.c_territ_036(+)
        AND c_territ_033 = c_territ_035(+)
        AND n_impug_033 = n_impug_035(+)
        AND ano_impug_033 = ano_impug_035(+)
        AND c_sindi_035 = c_sindi_019(+)
   GROUP BY    w83b_33s00.c_territ_033
            || '/'
            || w83b_33s00.ano_impug_033
            || '/'
            || w83b_33s00.n_impug_033,
               w83b_33s00.c_territ_033
            || '/'
            || w83b_33s00.ano_preaviso_033
            || '/'
            || w83b_33s00.n_preaviso_033,
               w83b_33s00.c_territ_033
            || '/'
            || w83b_33s00.ano_acta_033
            || '/'
            || w83b_33s00.n_acta_033,
            w83b_33s00.ano_impug_033,
            w83b_33s00.n_impug_033,
            w83b_33s00.c_territ_033,
            w83b_33s00.ano_preaviso_033,
            w83b_33s00.n_preaviso_033,
            w83b_33s00.ano_acta_033,
            w83b_33s00.n_acta_033,
            w83b_33s00.version_033,
            w83b_68s00.ano_laudo_068,
            w83b_68s00.n_laudo_068,
            w83b_33s00.f_impug_033,
            w83b_33s00.dni_033,
            w83b_36s00.nombre_036,
            w83b_33s00.fenvarb_033,
            w83b_33s00.fenvjuz_033,
            w83b_33s00.f_senten_033,
            w83b_33s00.c_impug_033,
            w83b_30s00.desc_030,
            w83b_30s00.dese_030,
            w83b_33s00.asunto_033,
            w83b_33s00.decisiob_033,
               w83b_33s00.c_territ_033
            || '/'
            || w83b_68s00.ano_laudo_068
            || '/'
            || w83b_68s00.n_laudo_068,
            w83b_68s00.flaudo_068,
            w83b_33s00.fdeses_033,
            w83b_68s00.rdo_laudo_068,
            w83b_75s00.desc_rdo_cas_075,
            w83b_75s00.desc_rdo_eus_075,
            w83b_16s00.id_centro_016,
            w83b_37s00.id_centro_037,
            w83b_33s00.n_regis_033,
            w83b_33s00.f_regis_033,
            w83b_76s00.dni_imp_076,
            w83b_76s00.nombre_imp_076,
            w83b_76s00.dir_imp_076,
            w83b_76s00.codpos_imp_076,
            w83b_76s00.mun_imp_076,
            w83b_76s00.prov_imp_076,
            w83b_59s00.id_centro_059;
/
CREATE OR REPLACE FORCE VIEW w83b.w83bvistaimpugnaciones (nimpugnacion,
                                                          npreaviso,
                                                          nacta,
                                                          anyoimpugnacion,
                                                          numimpugnacion,
                                                          codterritorioimpugnacion,
                                                          anyopreaviso,
                                                          numpreaviso,
                                                          anyoacta,
                                                          numacta,
                                                          VERSION,
                                                          anyolaudo,
                                                          numlaudo,
                                                          fimpugnaciondate,
                                                          arbitro,
                                                          nomarbitro,
                                                          fenvioarbitrodate,
                                                          fenviojuzgadodate,
                                                          fsentenciadate,
                                                          tipoimpug,
                                                          desctipoimpug,
                                                          desetipoimpug,
                                                          asunto,
                                                          decision,
                                                          nlaudo,
                                                          flaudodate,
                                                          fdesestimientodate,
                                                          resultado,
                                                          descresultado,
                                                          deseresultado,
                                                          idcentro,
                                                          ncentro,
                                                          cif,
                                                          dircentro,
                                                          codmunicipio,
                                                          codprovincia,
                                                          centromunicipiotxtc,
                                                          centromunicipiotxte,
                                                          centroprovinciatxtc,
                                                          centroprovinciatxte,
                                                          razonsocial,
                                                          nregistro,
                                                          fregistrodate,
                                                          dniimpug,
                                                          nombreimpug,
                                                          dirimpug,
                                                          cpimpug,
                                                          muniimpug,
                                                          provimpug,
                                                          muniimpugtxtc,
                                                          muniimpugtxte,
                                                          provimpugtxtc,
                                                          provimpugtxte,
                                                          citacion,
                                                          codvoces,
                                                          descvoces,
                                                          desevoces,
                                                          codsindicatos,
                                                          descsindicatos,
                                                          desesindicatos,
                                                          nimpugnacionesint,
                                                          npreavisosint,
                                                          nactasint,
                                                          nlaudosint,
                                                          abrsindicatos
                                                         )
AS
   SELECT      w83b_33s00.c_territ_033
            || '/'
            || w83b_33s00.ano_impug_033
            || '/'
            || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_impug_033)),
                       1, '00000' || TO_CHAR (w83b_33s00.n_impug_033),
                       2, '0000' || TO_CHAR (w83b_33s00.n_impug_033),
                       3, '000' || TO_CHAR (w83b_33s00.n_impug_033),
                       4, '00' || TO_CHAR (w83b_33s00.n_impug_033),
                       5, '0' || TO_CHAR (w83b_33s00.n_impug_033),
                       TO_CHAR (w83b_33s00.n_impug_033)
                      ),
               w83b_33s00.c_territ_033
            || '/'
            || w83b_33s00.ano_preaviso_033
            || '/'
            || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_preaviso_033)),
                       1, '00000' || TO_CHAR (w83b_33s00.n_preaviso_033),
                       2, '0000' || TO_CHAR (w83b_33s00.n_preaviso_033),
                       3, '000' || TO_CHAR (w83b_33s00.n_preaviso_033),
                       4, '00' || TO_CHAR (w83b_33s00.n_preaviso_033),
                       5, '0' || TO_CHAR (w83b_33s00.n_preaviso_033),
                       TO_CHAR (w83b_33s00.n_preaviso_033)
                      ),
               w83b_33s00.c_territ_033
            || '/'
            || w83b_33s00.ano_acta_033
            || '/'
            || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_acta_033)),
                       1, '00000' || TO_CHAR (w83b_33s00.n_acta_033),
                       2, '0000' || TO_CHAR (w83b_33s00.n_acta_033),
                       3, '000' || TO_CHAR (w83b_33s00.n_acta_033),
                       4, '00' || TO_CHAR (w83b_33s00.n_acta_033),
                       5, '0' || TO_CHAR (w83b_33s00.n_acta_033),
                       TO_CHAR (w83b_33s00.n_acta_033)
                      ),
            w83b_33s00.ano_impug_033,
            DECODE (LENGTH (TO_CHAR (w83b_33s00.n_impug_033)),
                    1, '00000' || TO_CHAR (w83b_33s00.n_impug_033),
                    2, '0000' || TO_CHAR (w83b_33s00.n_impug_033),
                    3, '000' || TO_CHAR (w83b_33s00.n_impug_033),
                    4, '00' || TO_CHAR (w83b_33s00.n_impug_033),
                    5, '0' || TO_CHAR (w83b_33s00.n_impug_033),
                    TO_CHAR (w83b_33s00.n_impug_033)
                   ),
            w83b_33s00.c_territ_033, w83b_33s00.ano_preaviso_033,
            DECODE (LENGTH (TO_CHAR (w83b_33s00.n_preaviso_033)),
                    1, '00000' || TO_CHAR (w83b_33s00.n_preaviso_033),
                    2, '0000' || TO_CHAR (w83b_33s00.n_preaviso_033),
                    3, '000' || TO_CHAR (w83b_33s00.n_preaviso_033),
                    4, '00' || TO_CHAR (w83b_33s00.n_preaviso_033),
                    5, '0' || TO_CHAR (w83b_33s00.n_preaviso_033),
                    TO_CHAR (w83b_33s00.n_preaviso_033)
                   ),
            w83b_33s00.ano_acta_033,
            DECODE (LENGTH (TO_CHAR (w83b_33s00.n_acta_033)),
                    1, '00000' || TO_CHAR (w83b_33s00.n_acta_033),
                    2, '0000' || TO_CHAR (w83b_33s00.n_acta_033),
                    3, '000' || TO_CHAR (w83b_33s00.n_acta_033),
                    4, '00' || TO_CHAR (w83b_33s00.n_acta_033),
                    5, '0' || TO_CHAR (w83b_33s00.n_acta_033),
                    TO_CHAR (w83b_33s00.n_acta_033)
                   ),
            w83b_33s00.version_033, w83b_68s00.ano_laudo_068,
            DECODE (LENGTH (TO_CHAR (w83b_68s00.n_laudo_068)),
                    1, '00' || TO_CHAR (w83b_68s00.n_laudo_068),
                    2, '0' || TO_CHAR (w83b_68s00.n_laudo_068),
                    TO_CHAR (w83b_68s00.n_laudo_068)
                   ),
            w83b_33s00.f_impug_033, w83b_33s00.dni_033, w83b_36s00.nombre_036,
            w83b_33s00.fenvarb_033, w83b_33s00.fenvjuz_033,
            w83b_33s00.f_senten_033, w83b_33s00.c_impug_033,
            w83b_30s00.desc_030, w83b_30s00.dese_030, w83b_33s00.asunto_033,
            w83b_33s00.decisiob_033,
               w83b_33s00.c_territ_033
            || '/'
            || w83b_68s00.ano_laudo_068
            || '/'
            || DECODE (LENGTH (TO_CHAR (w83b_68s00.n_laudo_068)),
                       1, '00' || TO_CHAR (w83b_68s00.n_laudo_068),
                       2, '0' || TO_CHAR (w83b_68s00.n_laudo_068),
                       TO_CHAR (w83b_68s00.n_laudo_068)
                      ),
            w83b_68s00.flaudo_068, w83b_33s00.fdeses_033,
            w83b_68s00.rdo_laudo_068, w83b_75s00.desc_rdo_cas_075,
            w83b_75s00.desc_rdo_eus_075, t73_01s00.ccen_001,
            t73_01s00.ncen_001, t73_01s00.ccif_001, t73_01s00.domic_001,
            t73_01s00.munic_001, t73_01s00.provc_001, fca02.ds_o, fca02.ds_o,
            fca01.ds_o, fca01.ds_o, t73_01s00.rsoc_001,
            w83b_33s00.n_regis_033, w83b_33s00.f_regis_033,
            w83b_76s00.dni_imp_076, w83b_76s00.nombre_imp_076,
            w83b_76s00.dir_imp_076, w83b_76s00.codpos_imp_076,
            w83b_76s00.mun_imp_076, w83b_76s00.prov_imp_076, fca02_impug.ds_o,
            fca02_impug.ds_o, fca01_impug.ds_o, fca01_impug.ds_o,
            w83b_59s00.id_centro_059,
            stragg_int (DISTINCT (   w83b_31s00.ctipvoz_031
                                  || '|'
                                  || w83b_31s00.cvoz_031
                                  || '|'
                                  || w83b_34s00.sino_034
                         )
                       ),
            stragg_int (DISTINCT (   w83b_32s00.desc_032
                                  || '|'
                                  || w83b_31s00.desc_031
                                  || '@'
                                  || w83b_31s00.ctipvoz_031
                                  || '|'
                                  || w83b_31s00.cvoz_031
                                  || '|'
                                  || w83b_34s00.sino_034
                         )
                       ),
            stragg_int (DISTINCT (   w83b_32s00.dese_032
                                  || '|'
                                  || w83b_31s00.dese_031
                                  || '@'
                                  || w83b_31s00.ctipvoz_031
                                  || '|'
                                  || w83b_31s00.cvoz_031
                                  || '|'
                                  || w83b_34s00.sino_034
                         )
                       ),
            stragg_int (DISTINCT (w83b_19s00.c_sindi_019)),
            stragg_int (DISTINCT (   w83b_19s00.desc_019
                                  || '@'
                                  || w83b_19s00.c_sindi_019
                         )
                       ),
            stragg_int (DISTINCT (   w83b_19s00.dese_019
                                  || '@'
                                  || w83b_19s00.c_sindi_019
                         )
                       ),
            TO_NUMBER
               (   w83b_33s00.ano_impug_033
                || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_impug_033)),
                           1, '00000' || TO_CHAR (w83b_33s00.n_impug_033),
                           2, '0000' || TO_CHAR (w83b_33s00.n_impug_033),
                           3, '000' || TO_CHAR (w83b_33s00.n_impug_033),
                           4, '00' || TO_CHAR (w83b_33s00.n_impug_033),
                           5, '0' || TO_CHAR (w83b_33s00.n_impug_033),
                           TO_CHAR (w83b_33s00.n_impug_033)
                          )
               ) AS nimpugnacionesint,
            TO_NUMBER
               (   w83b_33s00.ano_preaviso_033
                || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_preaviso_033)),
                           1, '00000' || TO_CHAR (w83b_33s00.n_preaviso_033),
                           2, '0000' || TO_CHAR (w83b_33s00.n_preaviso_033),
                           3, '000' || TO_CHAR (w83b_33s00.n_preaviso_033),
                           4, '00' || TO_CHAR (w83b_33s00.n_preaviso_033),
                           5, '0' || TO_CHAR (w83b_33s00.n_preaviso_033),
                           TO_CHAR (w83b_33s00.n_preaviso_033)
                          )
               ) AS npreavisosint,
            TO_NUMBER
                (   w83b_33s00.ano_acta_033
                 || DECODE (LENGTH (TO_CHAR (w83b_33s00.n_acta_033)),
                            1, '00000' || TO_CHAR (w83b_33s00.n_acta_033),
                            2, '0000' || TO_CHAR (w83b_33s00.n_acta_033),
                            3, '000' || TO_CHAR (w83b_33s00.n_acta_033),
                            4, '00' || TO_CHAR (w83b_33s00.n_acta_033),
                            5, '0' || TO_CHAR (w83b_33s00.n_acta_033),
                            TO_CHAR (w83b_33s00.n_acta_033)
                           )
                ) AS nactasint,
            TO_NUMBER
               (   w83b_68s00.ano_laudo_068
                || DECODE (LENGTH (TO_CHAR (w83b_68s00.n_laudo_068)),
                           1, '00' || TO_CHAR (w83b_68s00.n_laudo_068),
                           2, '0' || TO_CHAR (w83b_68s00.n_laudo_068),
                           TO_CHAR (w83b_68s00.n_laudo_068)
                          )
               ) AS nlaudosint,
            stragg_int (DISTINCT (w83b_19s00.siglas_019))
       FROM w83b33s00 w83b_33s00,
            w83b68s00 w83b_68s00,
            w83b30s00 w83b_30s00,
            w83b59s00 w83b_59s00,
            w83b75s00 w83b_75s00,
            w83b34s00 w83b_34s00,
            w83b31s00 w83b_31s00,
            w83b32s00 w83b_32s00,
            w83b37s00 w83b_37s00,
            w83b16s00 w83b_16s00,
            w83b76s00 w83b_76s00,
            t17i.t17_municipio fca02_impug,
            t17i.t17_provincia fca01_impug,
            w83b36s00 w83b_36s00,
            j7301s01 t73_01s00,
            t17i.t17_municipio fca02,
            t17i.t17_provincia fca01,
            w83b35s00 w83b_35s00,
            w83b19s00 w83b_19s00
      WHERE c_impug_033 = c_impug_030
        AND c_territ_033 = c_territ_068(+)
        AND n_impug_033 = n_impug_068(+)
        AND ano_impug_033 = ano_impug_068(+)
        AND c_territ_033 = c_territ_059(+)
        AND n_impug_033 = num_impugnac_059(+)
        AND ano_impug_033 = ano_impugn_059(+)
        AND rdo_laudo_068 = id_rdo_075(+)
        AND c_territ_068 = c_territ_034(+)
        AND n_impug_068 = n_impug_034(+)
        AND ano_impug_068 = ano_impug_034(+)
        AND n_laudo_068 = n_laudo_034(+)
        AND ano_laudo_068 = ano_laudo_034(+)
        AND ctipvoz_034 = ctipvoz_031(+)
        AND cvoz_034 = cvoz_031(+)
        AND ctipvoz_031 = ctipvoz_032(+)
        AND c_territ_033 = c_territ_037(+)
        AND n_preaviso_033 = n_preaviso_037(+)
        AND ano_preaviso_033 = ano_preaviso_037(+)
        AND c_territ_033 = c_territ_016(+)
        AND n_acta_033 = n_acta_016(+)
        AND ano_acta_033 = ano_acta_016(+)
        AND version_033 = version_016(+)
        AND c_territ_033 = c_territ_076(+)
        AND n_impug_033 = n_impug_076(+)
        AND ano_impug_033 = ano_impug_076(+)
        AND w83b_76s00.prov_imp_076 = fca02_impug.provincia_id(+)
        AND w83b_76s00.mun_imp_076 = fca02_impug.ID(+)
        AND w83b_76s00.prov_imp_076 = fca01_impug.ID(+)
        AND dni_033 = dni_036(+)
        AND c_territ_033 = w83b_36s00.c_territ_036(+)
        AND (   (    w83b_37s00.id_centro_037 IS NULL
                 AND t73_01s00.ccen_001 = w83b_16s00.id_centro_016
                )
             OR (    w83b_16s00.id_centro_016 IS NULL
                 AND t73_01s00.ccen_001 = w83b_37s00.id_centro_037
                )
            )
        AND t73_01s00.provc_001 = fca02.provincia_id(+)
        AND t73_01s00.munic_001 = fca02.ID(+)
        AND t73_01s00.provc_001 = fca01.ID(+)
        AND c_territ_033 = c_territ_035(+)
        AND n_impug_033 = n_impug_035(+)
        AND ano_impug_033 = ano_impug_035(+)
        AND c_sindi_035 = c_sindi_019(+)
   GROUP BY    w83b_33s00.c_territ_033
            || '/'
            || w83b_33s00.ano_impug_033
            || '/'
            || w83b_33s00.n_impug_033,
               w83b_33s00.c_territ_033
            || '/'
            || w83b_33s00.ano_preaviso_033
            || '/'
            || w83b_33s00.n_preaviso_033,
               w83b_33s00.c_territ_033
            || '/'
            || w83b_33s00.ano_acta_033
            || '/'
            || w83b_33s00.n_acta_033,
            w83b_33s00.ano_impug_033,
            w83b_33s00.n_impug_033,
            w83b_33s00.c_territ_033,
            w83b_33s00.ano_preaviso_033,
            w83b_33s00.n_preaviso_033,
            w83b_33s00.ano_acta_033,
            w83b_33s00.n_acta_033,
            w83b_33s00.version_033,
            w83b_68s00.ano_laudo_068,
            w83b_68s00.n_laudo_068,
            w83b_33s00.f_impug_033,
            w83b_33s00.dni_033,
            w83b_36s00.nombre_036,
            w83b_33s00.fenvarb_033,
            w83b_33s00.fenvjuz_033,
            w83b_33s00.f_senten_033,
            w83b_33s00.c_impug_033,
            w83b_30s00.desc_030,
            w83b_30s00.dese_030,
            w83b_33s00.asunto_033,
            w83b_33s00.decisiob_033,
               w83b_33s00.c_territ_033
            || '/'
            || w83b_68s00.ano_laudo_068
            || '/'
            || w83b_68s00.n_laudo_068,
            w83b_68s00.flaudo_068,
            w83b_33s00.fdeses_033,
            w83b_68s00.rdo_laudo_068,
            w83b_75s00.desc_rdo_cas_075,
            w83b_75s00.desc_rdo_eus_075,
            t73_01s00.ccen_001,
            t73_01s00.ncen_001,
            t73_01s00.ccif_001,
            t73_01s00.domic_001,
            t73_01s00.munic_001,
            t73_01s00.provc_001,
            fca02.ds_o,
            fca02.ds_o,
            fca01.ds_o,
            fca01.ds_o,
            t73_01s00.rsoc_001,
            w83b_33s00.n_regis_033,
            w83b_33s00.f_regis_033,
            w83b_76s00.dni_imp_076,
            w83b_76s00.nombre_imp_076,
            w83b_76s00.dir_imp_076,
            w83b_76s00.codpos_imp_076,
            w83b_76s00.mun_imp_076,
            w83b_76s00.prov_imp_076,
            fca02_impug.ds_o,
            fca02_impug.ds_o,
            fca01_impug.ds_o,
            fca01_impug.ds_o,
            w83b_59s00.id_centro_059;
/
CREATE OR REPLACE FORCE VIEW w83b.w83bvistaimpugnacionesactas (nimpugnacion,
                                                               npreaviso,
                                                               nacta,
                                                               ano_impug,
                                                               num_impug,
                                                               territ,
                                                               ano_preaviso,
                                                               num_preaviso,
                                                               ano_acta,
                                                               num_acta,
                                                               VERSION,
                                                               ano_laudo,
                                                               num_laudo,
                                                               fimpugnaciondate,
                                                               arbitro,
                                                               nomarbitro,
                                                               fenvioarbitrodate,
                                                               fenviojuzgadodate,
                                                               fsentenciadate,
                                                               tipoimpug,
                                                               desctipoimpug,
                                                               desetipoimpug,
                                                               asunto,
                                                               decision,
                                                               laudo,
                                                               fechalaudo,
                                                               fechadeses,
                                                               resultadolaudo,
                                                               nregistro,
                                                               fregistrodate,
                                                               sindicatos,
                                                               nombreimpugnante
                                                              )
AS
   SELECT      w83b_33s00.c_territ_033
            || '/'
            || w83b_33s00.ano_impug_033
            || '/'
            || w83b_33s00.n_impug_033 AS impugnacion,
               w83b_33s00.c_territ_033
            || '/'
            || w83b_33s00.ano_preaviso_033
            || '/'
            || w83b_33s00.n_preaviso_033 AS preaviso,
               w83b_33s00.c_territ_033
            || '/'
            || w83b_33s00.ano_acta_033
            || '/'
            || w83b_33s00.n_acta_033 AS acta,
            w83b_33s00.ano_impug_033, w83b_33s00.n_impug_033,
            w83b_33s00.c_territ_033, w83b_33s00.ano_preaviso_033,
            w83b_33s00.n_preaviso_033, w83b_33s00.ano_acta_033,
            w83b_33s00.n_acta_033, w83b_33s00.version_033,
            w83b_68s00.ano_laudo_068, w83b_68s00.n_laudo_068,
            w83b_33s00.f_impug_033, w83b_33s00.dni_033, w83b_36s00.nombre_036,
            w83b_33s00.fenvarb_033, w83b_33s00.fenvjuz_033,
            w83b_33s00.f_senten_033, w83b_33s00.c_impug_033,
            w83b_30s00.desc_030, w83b_30s00.dese_030, w83b_33s00.asunto_033,
            w83b_33s00.decisiob_033,
               w83b_33s00.c_territ_033
            || '/'
            || w83b_68s00.ano_laudo_068
            || '/'
            || w83b_68s00.n_laudo_068 AS laudo,
            w83b_68s00.flaudo_068, w83b_33s00.fdeses_033,
            w83b_68s00.rdo_laudo_068, w83b_33s00.n_regis_033,
            w83b_33s00.f_regis_033,            
            --stragg (DISTINCT (w83b_19s00.c_sindi_019)),
            stragg (w83b_19s00.siglas_019) AS sindicato, nombre_imp_076
       FROM w83b33s00 w83b_33s00 LEFT OUTER JOIN w83b30s00 w83b_30s00
            ON (c_impug_033 = c_impug_030)
            LEFT OUTER JOIN w83b68s00 w83b_68s00
            ON (    c_territ_033 = c_territ_068
                AND n_impug_033 = n_impug_068
                AND ano_impug_033 = ano_impug_068
               )
            LEFT OUTER JOIN w83b37s00 w83b_37s00
            ON (    c_territ_033 = c_territ_037
                AND n_preaviso_033 = n_preaviso_037
                AND ano_preaviso_033 = ano_preaviso_037
                AND n_acta_033 IS NULL
               )
            LEFT OUTER JOIN w83b16s00 w83b_16s00
            ON (    c_territ_033 = c_territ_016
                AND n_acta_033 = n_acta_016
                AND ano_acta_033 = ano_acta_016
                AND version_033 = version_016
               )
            LEFT OUTER JOIN w83b36s00 w83b_36s00
            ON (dni_033 = dni_036 AND c_territ_033 = c_territ_036)
            LEFT OUTER JOIN w83b35s00 w83b_35s00
            ON (    c_territ_033 = c_territ_035
                AND n_impug_033 = n_impug_035
                AND ano_impug_033 = ano_impug_035
               )
            LEFT OUTER JOIN w83b19s00 w83b_19s00 ON (c_sindi_035 = c_sindi_019
                                                    )
            LEFT OUTER JOIN w83b76t00
            ON (    c_territ_076 = c_territ_033
                AND ano_impug_076 = ano_impug_033
                AND n_impug_076 = n_impug_033
               )
   GROUP BY    w83b_33s00.c_territ_033
            || '/'
            || w83b_33s00.ano_impug_033
            || '/'
            || w83b_33s00.n_impug_033,
               w83b_33s00.c_territ_033
            || '/'
            || w83b_33s00.ano_preaviso_033
            || '/'
            || w83b_33s00.n_preaviso_033,
               w83b_33s00.c_territ_033
            || '/'
            || w83b_33s00.ano_acta_033
            || '/'
            || w83b_33s00.n_acta_033,
            w83b_33s00.ano_impug_033,
            w83b_33s00.n_impug_033,
            w83b_33s00.c_territ_033,
            w83b_33s00.ano_preaviso_033,
            w83b_33s00.n_preaviso_033,
            w83b_33s00.ano_acta_033,
            w83b_33s00.n_acta_033,
            w83b_33s00.version_033,
            w83b_68s00.ano_laudo_068,
            w83b_68s00.n_laudo_068,
            w83b_33s00.f_impug_033,
            w83b_33s00.dni_033,
            w83b_36s00.nombre_036,
            w83b_33s00.fenvarb_033,
            w83b_33s00.fenvjuz_033,
            w83b_33s00.f_senten_033,
            w83b_33s00.c_impug_033,
            w83b_30s00.desc_030,
            w83b_30s00.dese_030,
            w83b_33s00.asunto_033,
            w83b_33s00.decisiob_033,
               w83b_33s00.c_territ_033
            || '/'
            || w83b_68s00.ano_laudo_068
            || '/'
            || w83b_68s00.n_laudo_068,
            w83b_68s00.flaudo_068,
            w83b_33s00.fdeses_033,
            w83b_68s00.rdo_laudo_068,
            w83b_33s00.n_regis_033,
            w83b_33s00.f_regis_033,
            nombre_imp_076;
/			